using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents VistALink security fault
	/// message as defined in secFault.xsd (VistALink protocol specification).
	/// </summary>
	public sealed class SecurityFaultMessage : BaseFaultMessage
	{
		/// <summary>
		/// VistALink message type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string MessageType = "gov.va.med.foundations.security.fault";

		/// <summary>
		/// VistALink message XSD schema file name string. 		
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string XsdName = "secFault.xsd";

		/// <summary>
		/// Contstructor specifying minimal required VistALink security fault message parameters. 
		/// </summary>
		/// <param name="faultInfo">Fault info object containing information about the fault.</param>
		public SecurityFaultMessage( FaultInfo faultInfo )
			: base( MessageType, XsdName, faultInfo ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public SecurityFaultMessage( XmlDocument sourceDoc )
			: base( MessageType, XsdName, sourceDoc ) 
		{
			SecurityMessageImplementationMixin.ParseCommonSecurityXmlContent( sourceDoc );
		}

		/// <summary>
		/// Standard VistALink message XML serialization method, 
		/// translating message object into XML representation.
		/// </summary>
		/// <param name="writer">XmlWriter object to use for serialization.</param>
		protected override void WriteXmlMessageBody( XmlWriter writer )
		{
			SecurityMessageImplementationMixin.WriteCommonSecurityXmlContent( writer );
			base.WriteXmlMessageBody( writer );
		}
	}
}
